<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MyBusinessLodging;

class Sustainability extends \Google\Model
{
  protected $energyEfficiencyType = EnergyEfficiency::class;
  protected $energyEfficiencyDataType = '';
  protected $sustainabilityCertificationsType = SustainabilityCertifications::class;
  protected $sustainabilityCertificationsDataType = '';
  protected $sustainableSourcingType = SustainableSourcing::class;
  protected $sustainableSourcingDataType = '';
  protected $wasteReductionType = WasteReduction::class;
  protected $wasteReductionDataType = '';
  protected $waterConservationType = WaterConservation::class;
  protected $waterConservationDataType = '';

  /**
   * Energy efficiency practices implemented at the hotel.
   *
   * @param EnergyEfficiency $energyEfficiency
   */
  public function setEnergyEfficiency(EnergyEfficiency $energyEfficiency)
  {
    $this->energyEfficiency = $energyEfficiency;
  }
  /**
   * @return EnergyEfficiency
   */
  public function getEnergyEfficiency()
  {
    return $this->energyEfficiency;
  }
  /**
   * Sustainability certifications the hotel has been awarded. Deprecated: this
   * field is no longer populated. All certification data is now provided by
   * BeCause.
   *
   * @deprecated
   * @param SustainabilityCertifications $sustainabilityCertifications
   */
  public function setSustainabilityCertifications(SustainabilityCertifications $sustainabilityCertifications)
  {
    $this->sustainabilityCertifications = $sustainabilityCertifications;
  }
  /**
   * @deprecated
   * @return SustainabilityCertifications
   */
  public function getSustainabilityCertifications()
  {
    return $this->sustainabilityCertifications;
  }
  /**
   * Sustainable sourcing practices implemented at the hotel.
   *
   * @param SustainableSourcing $sustainableSourcing
   */
  public function setSustainableSourcing(SustainableSourcing $sustainableSourcing)
  {
    $this->sustainableSourcing = $sustainableSourcing;
  }
  /**
   * @return SustainableSourcing
   */
  public function getSustainableSourcing()
  {
    return $this->sustainableSourcing;
  }
  /**
   * Waste reduction practices implemented at the hotel.
   *
   * @param WasteReduction $wasteReduction
   */
  public function setWasteReduction(WasteReduction $wasteReduction)
  {
    $this->wasteReduction = $wasteReduction;
  }
  /**
   * @return WasteReduction
   */
  public function getWasteReduction()
  {
    return $this->wasteReduction;
  }
  /**
   * Water conservation practices implemented at the hotel.
   *
   * @param WaterConservation $waterConservation
   */
  public function setWaterConservation(WaterConservation $waterConservation)
  {
    $this->waterConservation = $waterConservation;
  }
  /**
   * @return WaterConservation
   */
  public function getWaterConservation()
  {
    return $this->waterConservation;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Sustainability::class, 'Google_Service_MyBusinessLodging_Sustainability');
