<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MapsPlaces;

class GoogleMapsPlacesV1RoutingSummary extends \Google\Collection
{
  protected $collection_key = 'legs';
  /**
   * A link to show directions on Google Maps using the waypoints from the given
   * routing summary. The route generated by this link is not guaranteed to be
   * the same as the route used to generate the routing summary. The link uses
   * information provided in the request, from fields including
   * `routingParameters` and `searchAlongRouteParameters` when applicable, to
   * generate the directions link.
   *
   * @var string
   */
  public $directionsUri;
  protected $legsType = GoogleMapsPlacesV1RoutingSummaryLeg::class;
  protected $legsDataType = 'array';

  /**
   * A link to show directions on Google Maps using the waypoints from the given
   * routing summary. The route generated by this link is not guaranteed to be
   * the same as the route used to generate the routing summary. The link uses
   * information provided in the request, from fields including
   * `routingParameters` and `searchAlongRouteParameters` when applicable, to
   * generate the directions link.
   *
   * @param string $directionsUri
   */
  public function setDirectionsUri($directionsUri)
  {
    $this->directionsUri = $directionsUri;
  }
  /**
   * @return string
   */
  public function getDirectionsUri()
  {
    return $this->directionsUri;
  }
  /**
   * The legs of the trip. When you calculate travel duration and distance from
   * a set origin, `legs` contains a single leg containing the duration and
   * distance from the origin to the destination. When you do a search along
   * route, `legs` contains two legs: one from the origin to place, and one from
   * the place to the destination.
   *
   * @param GoogleMapsPlacesV1RoutingSummaryLeg[] $legs
   */
  public function setLegs($legs)
  {
    $this->legs = $legs;
  }
  /**
   * @return GoogleMapsPlacesV1RoutingSummaryLeg[]
   */
  public function getLegs()
  {
    return $this->legs;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleMapsPlacesV1RoutingSummary::class, 'Google_Service_MapsPlaces_GoogleMapsPlacesV1RoutingSummary');
