<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Integrations;

class GoogleCloudIntegrationsV1alphaSuspensionAudit extends \Google\Model
{
  /**
   * Time at which this suspension was resolved.
   *
   * @var string
   */
  public $resolveTime;
  /**
   * Email address of the person who resolved this suspension.
   *
   * @var string
   */
  public $resolver;

  /**
   * Time at which this suspension was resolved.
   *
   * @param string $resolveTime
   */
  public function setResolveTime($resolveTime)
  {
    $this->resolveTime = $resolveTime;
  }
  /**
   * @return string
   */
  public function getResolveTime()
  {
    return $this->resolveTime;
  }
  /**
   * Email address of the person who resolved this suspension.
   *
   * @param string $resolver
   */
  public function setResolver($resolver)
  {
    $this->resolver = $resolver;
  }
  /**
   * @return string
   */
  public function getResolver()
  {
    return $this->resolver;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudIntegrationsV1alphaSuspensionAudit::class, 'Google_Service_Integrations_GoogleCloudIntegrationsV1alphaSuspensionAudit');
