<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dialogflow;

class GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo extends \Google\Model
{
  /**
   * Always present. The value of the Fulfillment.tag field will be populated in
   * this field by Dialogflow when the associated webhook is called. The tag is
   * typically used by the webhook service to identify which fulfillment is
   * being called, but it could be used for other purposes.
   *
   * @var string
   */
  public $tag;

  /**
   * Always present. The value of the Fulfillment.tag field will be populated in
   * this field by Dialogflow when the associated webhook is called. The tag is
   * typically used by the webhook service to identify which fulfillment is
   * being called, but it could be used for other purposes.
   *
   * @param string $tag
   */
  public function setTag($tag)
  {
    $this->tag = $tag;
  }
  /**
   * @return string
   */
  public function getTag()
  {
    return $this->tag;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo::class, 'Google_Service_Dialogflow_GoogleCloudDialogflowCxV3WebhookRequestFulfillmentInfo');
