<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dialogflow;

class GoogleCloudDialogflowCxV3Version extends \Google\Model
{
  /**
   * Not specified. This value is not used.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * Version is not ready to serve (e.g. training is running).
   */
  public const STATE_RUNNING = 'RUNNING';
  /**
   * Training has succeeded and this version is ready to serve.
   */
  public const STATE_SUCCEEDED = 'SUCCEEDED';
  /**
   * Version training failed.
   */
  public const STATE_FAILED = 'FAILED';
  /**
   * Output only. Create time of the version.
   *
   * @var string
   */
  public $createTime;
  /**
   * The description of the version. The maximum length is 500 characters. If
   * exceeded, the request is rejected.
   *
   * @var string
   */
  public $description;
  /**
   * Required. The human-readable name of the version. Limit of 64 characters.
   *
   * @var string
   */
  public $displayName;
  /**
   * Format: projects//locations//agents//flows//versions/. Version ID is a
   * self-increasing number generated by Dialogflow upon version creation.
   *
   * @var string
   */
  public $name;
  protected $nluSettingsType = GoogleCloudDialogflowCxV3NluSettings::class;
  protected $nluSettingsDataType = '';
  /**
   * Output only. The state of this version. This field is read-only and cannot
   * be set by create and update methods.
   *
   * @var string
   */
  public $state;

  /**
   * Output only. Create time of the version.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * The description of the version. The maximum length is 500 characters. If
   * exceeded, the request is rejected.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Required. The human-readable name of the version. Limit of 64 characters.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Format: projects//locations//agents//flows//versions/. Version ID is a
   * self-increasing number generated by Dialogflow upon version creation.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. The NLU settings of the flow at version creation.
   *
   * @param GoogleCloudDialogflowCxV3NluSettings $nluSettings
   */
  public function setNluSettings(GoogleCloudDialogflowCxV3NluSettings $nluSettings)
  {
    $this->nluSettings = $nluSettings;
  }
  /**
   * @return GoogleCloudDialogflowCxV3NluSettings
   */
  public function getNluSettings()
  {
    return $this->nluSettings;
  }
  /**
   * Output only. The state of this version. This field is read-only and cannot
   * be set by create and update methods.
   *
   * Accepted values: STATE_UNSPECIFIED, RUNNING, SUCCEEDED, FAILED
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDialogflowCxV3Version::class, 'Google_Service_Dialogflow_GoogleCloudDialogflowCxV3Version');
