<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dfareporting;

class PlacementsGenerateTagsResponse extends \Google\Collection
{
  protected $collection_key = 'placementTags';
  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#placementsGenerateTagsResponse".
   *
   * @var string
   */
  public $kind;
  protected $placementTagsType = PlacementTag::class;
  protected $placementTagsDataType = 'array';

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "dfareporting#placementsGenerateTagsResponse".
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Set of generated tags for the specified placements.
   *
   * @param PlacementTag[] $placementTags
   */
  public function setPlacementTags($placementTags)
  {
    $this->placementTags = $placementTags;
  }
  /**
   * @return PlacementTag[]
   */
  public function getPlacementTags()
  {
    return $this->placementTags;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PlacementsGenerateTagsResponse::class, 'Google_Service_Dfareporting_PlacementsGenerateTagsResponse');
