<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataproc;

class KerberosConfig extends \Google\Model
{
  /**
   * Optional. The admin server (IP or hostname) for the remote trusted realm in
   * a cross realm trust relationship.
   *
   * @var string
   */
  public $crossRealmTrustAdminServer;
  /**
   * Optional. The KDC (IP or hostname) for the remote trusted realm in a cross
   * realm trust relationship.
   *
   * @var string
   */
  public $crossRealmTrustKdc;
  /**
   * Optional. The remote realm the Dataproc on-cluster KDC will trust, should
   * the user enable cross realm trust.
   *
   * @var string
   */
  public $crossRealmTrustRealm;
  /**
   * Optional. The Cloud Storage URI of a KMS encrypted file containing the
   * shared password between the on-cluster Kerberos realm and the remote
   * trusted realm, in a cross realm trust relationship.
   *
   * @var string
   */
  public $crossRealmTrustSharedPasswordUri;
  /**
   * Optional. Flag to indicate whether to Kerberize the cluster (default:
   * false). Set this field to true to enable Kerberos on a cluster.
   *
   * @var bool
   */
  public $enableKerberos;
  /**
   * Optional. The Cloud Storage URI of a KMS encrypted file containing the
   * master key of the KDC database.
   *
   * @var string
   */
  public $kdcDbKeyUri;
  /**
   * Optional. The Cloud Storage URI of a KMS encrypted file containing the
   * password to the user provided key. For the self-signed certificate, this
   * password is generated by Dataproc.
   *
   * @var string
   */
  public $keyPasswordUri;
  /**
   * Optional. The Cloud Storage URI of a KMS encrypted file containing the
   * password to the user provided keystore. For the self-signed certificate,
   * this password is generated by Dataproc.
   *
   * @var string
   */
  public $keystorePasswordUri;
  /**
   * Optional. The Cloud Storage URI of the keystore file used for SSL
   * encryption. If not provided, Dataproc will provide a self-signed
   * certificate.
   *
   * @var string
   */
  public $keystoreUri;
  /**
   * Optional. The URI of the KMS key used to encrypt sensitive files.
   *
   * @var string
   */
  public $kmsKeyUri;
  /**
   * Optional. The name of the on-cluster Kerberos realm. If not specified, the
   * uppercased domain of hostnames will be the realm.
   *
   * @var string
   */
  public $realm;
  /**
   * Optional. The Cloud Storage URI of a KMS encrypted file containing the root
   * principal password.
   *
   * @var string
   */
  public $rootPrincipalPasswordUri;
  /**
   * Optional. The lifetime of the ticket granting ticket, in hours. If not
   * specified, or user specifies 0, then default value 10 will be used.
   *
   * @var int
   */
  public $tgtLifetimeHours;
  /**
   * Optional. The Cloud Storage URI of a KMS encrypted file containing the
   * password to the user provided truststore. For the self-signed certificate,
   * this password is generated by Dataproc.
   *
   * @var string
   */
  public $truststorePasswordUri;
  /**
   * Optional. The Cloud Storage URI of the truststore file used for SSL
   * encryption. If not provided, Dataproc will provide a self-signed
   * certificate.
   *
   * @var string
   */
  public $truststoreUri;

  /**
   * Optional. The admin server (IP or hostname) for the remote trusted realm in
   * a cross realm trust relationship.
   *
   * @param string $crossRealmTrustAdminServer
   */
  public function setCrossRealmTrustAdminServer($crossRealmTrustAdminServer)
  {
    $this->crossRealmTrustAdminServer = $crossRealmTrustAdminServer;
  }
  /**
   * @return string
   */
  public function getCrossRealmTrustAdminServer()
  {
    return $this->crossRealmTrustAdminServer;
  }
  /**
   * Optional. The KDC (IP or hostname) for the remote trusted realm in a cross
   * realm trust relationship.
   *
   * @param string $crossRealmTrustKdc
   */
  public function setCrossRealmTrustKdc($crossRealmTrustKdc)
  {
    $this->crossRealmTrustKdc = $crossRealmTrustKdc;
  }
  /**
   * @return string
   */
  public function getCrossRealmTrustKdc()
  {
    return $this->crossRealmTrustKdc;
  }
  /**
   * Optional. The remote realm the Dataproc on-cluster KDC will trust, should
   * the user enable cross realm trust.
   *
   * @param string $crossRealmTrustRealm
   */
  public function setCrossRealmTrustRealm($crossRealmTrustRealm)
  {
    $this->crossRealmTrustRealm = $crossRealmTrustRealm;
  }
  /**
   * @return string
   */
  public function getCrossRealmTrustRealm()
  {
    return $this->crossRealmTrustRealm;
  }
  /**
   * Optional. The Cloud Storage URI of a KMS encrypted file containing the
   * shared password between the on-cluster Kerberos realm and the remote
   * trusted realm, in a cross realm trust relationship.
   *
   * @param string $crossRealmTrustSharedPasswordUri
   */
  public function setCrossRealmTrustSharedPasswordUri($crossRealmTrustSharedPasswordUri)
  {
    $this->crossRealmTrustSharedPasswordUri = $crossRealmTrustSharedPasswordUri;
  }
  /**
   * @return string
   */
  public function getCrossRealmTrustSharedPasswordUri()
  {
    return $this->crossRealmTrustSharedPasswordUri;
  }
  /**
   * Optional. Flag to indicate whether to Kerberize the cluster (default:
   * false). Set this field to true to enable Kerberos on a cluster.
   *
   * @param bool $enableKerberos
   */
  public function setEnableKerberos($enableKerberos)
  {
    $this->enableKerberos = $enableKerberos;
  }
  /**
   * @return bool
   */
  public function getEnableKerberos()
  {
    return $this->enableKerberos;
  }
  /**
   * Optional. The Cloud Storage URI of a KMS encrypted file containing the
   * master key of the KDC database.
   *
   * @param string $kdcDbKeyUri
   */
  public function setKdcDbKeyUri($kdcDbKeyUri)
  {
    $this->kdcDbKeyUri = $kdcDbKeyUri;
  }
  /**
   * @return string
   */
  public function getKdcDbKeyUri()
  {
    return $this->kdcDbKeyUri;
  }
  /**
   * Optional. The Cloud Storage URI of a KMS encrypted file containing the
   * password to the user provided key. For the self-signed certificate, this
   * password is generated by Dataproc.
   *
   * @param string $keyPasswordUri
   */
  public function setKeyPasswordUri($keyPasswordUri)
  {
    $this->keyPasswordUri = $keyPasswordUri;
  }
  /**
   * @return string
   */
  public function getKeyPasswordUri()
  {
    return $this->keyPasswordUri;
  }
  /**
   * Optional. The Cloud Storage URI of a KMS encrypted file containing the
   * password to the user provided keystore. For the self-signed certificate,
   * this password is generated by Dataproc.
   *
   * @param string $keystorePasswordUri
   */
  public function setKeystorePasswordUri($keystorePasswordUri)
  {
    $this->keystorePasswordUri = $keystorePasswordUri;
  }
  /**
   * @return string
   */
  public function getKeystorePasswordUri()
  {
    return $this->keystorePasswordUri;
  }
  /**
   * Optional. The Cloud Storage URI of the keystore file used for SSL
   * encryption. If not provided, Dataproc will provide a self-signed
   * certificate.
   *
   * @param string $keystoreUri
   */
  public function setKeystoreUri($keystoreUri)
  {
    $this->keystoreUri = $keystoreUri;
  }
  /**
   * @return string
   */
  public function getKeystoreUri()
  {
    return $this->keystoreUri;
  }
  /**
   * Optional. The URI of the KMS key used to encrypt sensitive files.
   *
   * @param string $kmsKeyUri
   */
  public function setKmsKeyUri($kmsKeyUri)
  {
    $this->kmsKeyUri = $kmsKeyUri;
  }
  /**
   * @return string
   */
  public function getKmsKeyUri()
  {
    return $this->kmsKeyUri;
  }
  /**
   * Optional. The name of the on-cluster Kerberos realm. If not specified, the
   * uppercased domain of hostnames will be the realm.
   *
   * @param string $realm
   */
  public function setRealm($realm)
  {
    $this->realm = $realm;
  }
  /**
   * @return string
   */
  public function getRealm()
  {
    return $this->realm;
  }
  /**
   * Optional. The Cloud Storage URI of a KMS encrypted file containing the root
   * principal password.
   *
   * @param string $rootPrincipalPasswordUri
   */
  public function setRootPrincipalPasswordUri($rootPrincipalPasswordUri)
  {
    $this->rootPrincipalPasswordUri = $rootPrincipalPasswordUri;
  }
  /**
   * @return string
   */
  public function getRootPrincipalPasswordUri()
  {
    return $this->rootPrincipalPasswordUri;
  }
  /**
   * Optional. The lifetime of the ticket granting ticket, in hours. If not
   * specified, or user specifies 0, then default value 10 will be used.
   *
   * @param int $tgtLifetimeHours
   */
  public function setTgtLifetimeHours($tgtLifetimeHours)
  {
    $this->tgtLifetimeHours = $tgtLifetimeHours;
  }
  /**
   * @return int
   */
  public function getTgtLifetimeHours()
  {
    return $this->tgtLifetimeHours;
  }
  /**
   * Optional. The Cloud Storage URI of a KMS encrypted file containing the
   * password to the user provided truststore. For the self-signed certificate,
   * this password is generated by Dataproc.
   *
   * @param string $truststorePasswordUri
   */
  public function setTruststorePasswordUri($truststorePasswordUri)
  {
    $this->truststorePasswordUri = $truststorePasswordUri;
  }
  /**
   * @return string
   */
  public function getTruststorePasswordUri()
  {
    return $this->truststorePasswordUri;
  }
  /**
   * Optional. The Cloud Storage URI of the truststore file used for SSL
   * encryption. If not provided, Dataproc will provide a self-signed
   * certificate.
   *
   * @param string $truststoreUri
   */
  public function setTruststoreUri($truststoreUri)
  {
    $this->truststoreUri = $truststoreUri;
  }
  /**
   * @return string
   */
  public function getTruststoreUri()
  {
    return $this->truststoreUri;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(KerberosConfig::class, 'Google_Service_Dataproc_KerberosConfig');
