<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudVideoIntelligence;

class GoogleCloudVideointelligenceV1SpeechRecognitionAlternative extends \Google\Collection
{
  protected $collection_key = 'words';
  /**
   * Output only. The confidence estimate between 0.0 and 1.0. A higher number
   * indicates an estimated greater likelihood that the recognized words are
   * correct. This field is set only for the top alternative. This field is not
   * guaranteed to be accurate and users should not rely on it to be always
   * provided. The default of 0.0 is a sentinel value indicating `confidence`
   * was not set.
   *
   * @var float
   */
  public $confidence;
  /**
   * Transcript text representing the words that the user spoke.
   *
   * @var string
   */
  public $transcript;
  protected $wordsType = GoogleCloudVideointelligenceV1WordInfo::class;
  protected $wordsDataType = 'array';

  /**
   * Output only. The confidence estimate between 0.0 and 1.0. A higher number
   * indicates an estimated greater likelihood that the recognized words are
   * correct. This field is set only for the top alternative. This field is not
   * guaranteed to be accurate and users should not rely on it to be always
   * provided. The default of 0.0 is a sentinel value indicating `confidence`
   * was not set.
   *
   * @param float $confidence
   */
  public function setConfidence($confidence)
  {
    $this->confidence = $confidence;
  }
  /**
   * @return float
   */
  public function getConfidence()
  {
    return $this->confidence;
  }
  /**
   * Transcript text representing the words that the user spoke.
   *
   * @param string $transcript
   */
  public function setTranscript($transcript)
  {
    $this->transcript = $transcript;
  }
  /**
   * @return string
   */
  public function getTranscript()
  {
    return $this->transcript;
  }
  /**
   * Output only. A list of word-specific information for each recognized word.
   * Note: When `enable_speaker_diarization` is set to true, you will see all
   * the words from the beginning of the audio.
   *
   * @param GoogleCloudVideointelligenceV1WordInfo[] $words
   */
  public function setWords($words)
  {
    $this->words = $words;
  }
  /**
   * @return GoogleCloudVideointelligenceV1WordInfo[]
   */
  public function getWords()
  {
    return $this->words;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudVideointelligenceV1SpeechRecognitionAlternative::class, 'Google_Service_CloudVideoIntelligence_GoogleCloudVideointelligenceV1SpeechRecognitionAlternative');
