<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudSearch;

class Snippet extends \Google\Collection
{
  protected $collection_key = 'matchRanges';
  protected $matchRangesType = MatchRange::class;
  protected $matchRangesDataType = 'array';
  /**
   * The snippet of the document. May contain escaped HTML character that should
   * be unescaped prior to rendering.
   *
   * @var string
   */
  public $snippet;

  /**
   * The matched ranges in the snippet.
   *
   * @param MatchRange[] $matchRanges
   */
  public function setMatchRanges($matchRanges)
  {
    $this->matchRanges = $matchRanges;
  }
  /**
   * @return MatchRange[]
   */
  public function getMatchRanges()
  {
    return $this->matchRanges;
  }
  /**
   * The snippet of the document. May contain escaped HTML character that should
   * be unescaped prior to rendering.
   *
   * @param string $snippet
   */
  public function setSnippet($snippet)
  {
    $this->snippet = $snippet;
  }
  /**
   * @return string
   */
  public function getSnippet()
  {
    return $this->snippet;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Snippet::class, 'Google_Service_CloudSearch_Snippet');
