<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudDataplex;

class GoogleCloudDataplexV1GovernanceEventEntity extends \Google\Model
{
  /**
   * An unspecified Entity type.
   */
  public const ENTITY_TYPE_ENTITY_TYPE_UNSPECIFIED = 'ENTITY_TYPE_UNSPECIFIED';
  /**
   * Table entity type.
   */
  public const ENTITY_TYPE_TABLE = 'TABLE';
  /**
   * Fileset entity type.
   */
  public const ENTITY_TYPE_FILESET = 'FILESET';
  /**
   * The Entity resource the log event is associated with. Format: projects/{pro
   * ject_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entiti
   * es/{entity_id}
   *
   * @var string
   */
  public $entity;
  /**
   * Type of entity.
   *
   * @var string
   */
  public $entityType;

  /**
   * The Entity resource the log event is associated with. Format: projects/{pro
   * ject_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entiti
   * es/{entity_id}
   *
   * @param string $entity
   */
  public function setEntity($entity)
  {
    $this->entity = $entity;
  }
  /**
   * @return string
   */
  public function getEntity()
  {
    return $this->entity;
  }
  /**
   * Type of entity.
   *
   * Accepted values: ENTITY_TYPE_UNSPECIFIED, TABLE, FILESET
   *
   * @param self::ENTITY_TYPE_* $entityType
   */
  public function setEntityType($entityType)
  {
    $this->entityType = $entityType;
  }
  /**
   * @return self::ENTITY_TYPE_*
   */
  public function getEntityType()
  {
    return $this->entityType;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDataplexV1GovernanceEventEntity::class, 'Google_Service_CloudDataplex_GoogleCloudDataplexV1GovernanceEventEntity');
