<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidManagement;

class Enterprise extends \Google\Collection
{
  /**
   * This value is not used.
   */
  public const ENTERPRISE_TYPE_ENTERPRISE_TYPE_UNSPECIFIED = 'ENTERPRISE_TYPE_UNSPECIFIED';
  /**
   * The enterprise belongs to a managed Google domain (https://developers.googl
   * e.com/android/work/terminology#managed_google_domain).
   */
  public const ENTERPRISE_TYPE_MANAGED_GOOGLE_DOMAIN = 'MANAGED_GOOGLE_DOMAIN';
  /**
   * The enterprise is a managed Google Play Accounts enterprise (https://develo
   * pers.google.com/android/work/terminology#managed_google_play_accounts_enter
   * prise).
   */
  public const ENTERPRISE_TYPE_MANAGED_GOOGLE_PLAY_ACCOUNTS_ENTERPRISE = 'MANAGED_GOOGLE_PLAY_ACCOUNTS_ENTERPRISE';
  /**
   * The managed Google domain type is not specified.
   */
  public const MANAGED_GOOGLE_DOMAIN_TYPE_MANAGED_GOOGLE_DOMAIN_TYPE_UNSPECIFIED = 'MANAGED_GOOGLE_DOMAIN_TYPE_UNSPECIFIED';
  /**
   * The managed Google domain is an email-verified team.
   */
  public const MANAGED_GOOGLE_DOMAIN_TYPE_TYPE_TEAM = 'TYPE_TEAM';
  /**
   * The managed Google domain is domain-verified.
   */
  public const MANAGED_GOOGLE_DOMAIN_TYPE_TYPE_DOMAIN = 'TYPE_DOMAIN';
  /**
   * The managed Google Play Accounts enterprise type is not specified.
   */
  public const MANAGED_GOOGLE_PLAY_ACCOUNTS_ENTERPRISE_TYPE_MANAGED_GOOGLE_PLAY_ACCOUNTS_ENTERPRISE_TYPE_UNSPECIFIED = 'MANAGED_GOOGLE_PLAY_ACCOUNTS_ENTERPRISE_TYPE_UNSPECIFIED';
  /**
   * The enterprise is customer-managed
   */
  public const MANAGED_GOOGLE_PLAY_ACCOUNTS_ENTERPRISE_TYPE_CUSTOMER_MANAGED = 'CUSTOMER_MANAGED';
  /**
   * The enterprise is EMM-managed (deprecated).
   */
  public const MANAGED_GOOGLE_PLAY_ACCOUNTS_ENTERPRISE_TYPE_EMM_MANAGED = 'EMM_MANAGED';
  protected $collection_key = 'termsAndConditions';
  /**
   * Deprecated and unused.
   *
   * @deprecated
   * @var bool
   */
  public $appAutoApprovalEnabled;
  protected $contactInfoType = ContactInfo::class;
  protected $contactInfoDataType = '';
  /**
   * The types of Google Pub/Sub notifications enabled for the enterprise.
   *
   * @var string[]
   */
  public $enabledNotificationTypes;
  /**
   * The name of the enterprise displayed to users. This field has a maximum
   * length of 100 characters.
   *
   * @var string
   */
  public $enterpriseDisplayName;
  /**
   * Output only. The type of the enterprise.
   *
   * @var string
   */
  public $enterpriseType;
  protected $googleAuthenticationSettingsType = GoogleAuthenticationSettings::class;
  protected $googleAuthenticationSettingsDataType = '';
  protected $logoType = ExternalData::class;
  protected $logoDataType = '';
  /**
   * Output only. The type of managed Google domain.
   *
   * @var string
   */
  public $managedGoogleDomainType;
  /**
   * Output only. The type of a managed Google Play Accounts enterprise.
   *
   * @var string
   */
  public $managedGooglePlayAccountsEnterpriseType;
  /**
   * The name of the enterprise which is generated by the server during
   * creation, in the form enterprises/{enterpriseId}.
   *
   * @var string
   */
  public $name;
  /**
   * A color in RGB format that indicates the predominant color to display in
   * the device management app UI. The color components are stored as follows:
   * (red << 16) | (green << 8) | blue, where the value of each component is
   * between 0 and 255, inclusive.
   *
   * @var int
   */
  public $primaryColor;
  /**
   * The topic which Pub/Sub notifications are published to, in the form
   * projects/{project}/topics/{topic}. This field is only required if Pub/Sub
   * notifications are enabled.
   *
   * @var string
   */
  public $pubsubTopic;
  protected $signinDetailsType = SigninDetail::class;
  protected $signinDetailsDataType = 'array';
  protected $termsAndConditionsType = TermsAndConditions::class;
  protected $termsAndConditionsDataType = 'array';

  /**
   * Deprecated and unused.
   *
   * @deprecated
   * @param bool $appAutoApprovalEnabled
   */
  public function setAppAutoApprovalEnabled($appAutoApprovalEnabled)
  {
    $this->appAutoApprovalEnabled = $appAutoApprovalEnabled;
  }
  /**
   * @deprecated
   * @return bool
   */
  public function getAppAutoApprovalEnabled()
  {
    return $this->appAutoApprovalEnabled;
  }
  /**
   * The enterprise contact info of an EMM-managed enterprise.
   *
   * @param ContactInfo $contactInfo
   */
  public function setContactInfo(ContactInfo $contactInfo)
  {
    $this->contactInfo = $contactInfo;
  }
  /**
   * @return ContactInfo
   */
  public function getContactInfo()
  {
    return $this->contactInfo;
  }
  /**
   * The types of Google Pub/Sub notifications enabled for the enterprise.
   *
   * @param string[] $enabledNotificationTypes
   */
  public function setEnabledNotificationTypes($enabledNotificationTypes)
  {
    $this->enabledNotificationTypes = $enabledNotificationTypes;
  }
  /**
   * @return string[]
   */
  public function getEnabledNotificationTypes()
  {
    return $this->enabledNotificationTypes;
  }
  /**
   * The name of the enterprise displayed to users. This field has a maximum
   * length of 100 characters.
   *
   * @param string $enterpriseDisplayName
   */
  public function setEnterpriseDisplayName($enterpriseDisplayName)
  {
    $this->enterpriseDisplayName = $enterpriseDisplayName;
  }
  /**
   * @return string
   */
  public function getEnterpriseDisplayName()
  {
    return $this->enterpriseDisplayName;
  }
  /**
   * Output only. The type of the enterprise.
   *
   * Accepted values: ENTERPRISE_TYPE_UNSPECIFIED, MANAGED_GOOGLE_DOMAIN,
   * MANAGED_GOOGLE_PLAY_ACCOUNTS_ENTERPRISE
   *
   * @param self::ENTERPRISE_TYPE_* $enterpriseType
   */
  public function setEnterpriseType($enterpriseType)
  {
    $this->enterpriseType = $enterpriseType;
  }
  /**
   * @return self::ENTERPRISE_TYPE_*
   */
  public function getEnterpriseType()
  {
    return $this->enterpriseType;
  }
  /**
   * Settings for Google-provided user authentication.
   *
   * @param GoogleAuthenticationSettings $googleAuthenticationSettings
   */
  public function setGoogleAuthenticationSettings(GoogleAuthenticationSettings $googleAuthenticationSettings)
  {
    $this->googleAuthenticationSettings = $googleAuthenticationSettings;
  }
  /**
   * @return GoogleAuthenticationSettings
   */
  public function getGoogleAuthenticationSettings()
  {
    return $this->googleAuthenticationSettings;
  }
  /**
   * An image displayed as a logo during device provisioning. Supported types
   * are: image/bmp, image/gif, image/x-ico, image/jpeg, image/png, image/webp,
   * image/vnd.wap.wbmp, image/x-adobe-dng.
   *
   * @param ExternalData $logo
   */
  public function setLogo(ExternalData $logo)
  {
    $this->logo = $logo;
  }
  /**
   * @return ExternalData
   */
  public function getLogo()
  {
    return $this->logo;
  }
  /**
   * Output only. The type of managed Google domain.
   *
   * Accepted values: MANAGED_GOOGLE_DOMAIN_TYPE_UNSPECIFIED, TYPE_TEAM,
   * TYPE_DOMAIN
   *
   * @param self::MANAGED_GOOGLE_DOMAIN_TYPE_* $managedGoogleDomainType
   */
  public function setManagedGoogleDomainType($managedGoogleDomainType)
  {
    $this->managedGoogleDomainType = $managedGoogleDomainType;
  }
  /**
   * @return self::MANAGED_GOOGLE_DOMAIN_TYPE_*
   */
  public function getManagedGoogleDomainType()
  {
    return $this->managedGoogleDomainType;
  }
  /**
   * Output only. The type of a managed Google Play Accounts enterprise.
   *
   * Accepted values: MANAGED_GOOGLE_PLAY_ACCOUNTS_ENTERPRISE_TYPE_UNSPECIFIED,
   * CUSTOMER_MANAGED, EMM_MANAGED
   *
   * @param self::MANAGED_GOOGLE_PLAY_ACCOUNTS_ENTERPRISE_TYPE_* $managedGooglePlayAccountsEnterpriseType
   */
  public function setManagedGooglePlayAccountsEnterpriseType($managedGooglePlayAccountsEnterpriseType)
  {
    $this->managedGooglePlayAccountsEnterpriseType = $managedGooglePlayAccountsEnterpriseType;
  }
  /**
   * @return self::MANAGED_GOOGLE_PLAY_ACCOUNTS_ENTERPRISE_TYPE_*
   */
  public function getManagedGooglePlayAccountsEnterpriseType()
  {
    return $this->managedGooglePlayAccountsEnterpriseType;
  }
  /**
   * The name of the enterprise which is generated by the server during
   * creation, in the form enterprises/{enterpriseId}.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * A color in RGB format that indicates the predominant color to display in
   * the device management app UI. The color components are stored as follows:
   * (red << 16) | (green << 8) | blue, where the value of each component is
   * between 0 and 255, inclusive.
   *
   * @param int $primaryColor
   */
  public function setPrimaryColor($primaryColor)
  {
    $this->primaryColor = $primaryColor;
  }
  /**
   * @return int
   */
  public function getPrimaryColor()
  {
    return $this->primaryColor;
  }
  /**
   * The topic which Pub/Sub notifications are published to, in the form
   * projects/{project}/topics/{topic}. This field is only required if Pub/Sub
   * notifications are enabled.
   *
   * @param string $pubsubTopic
   */
  public function setPubsubTopic($pubsubTopic)
  {
    $this->pubsubTopic = $pubsubTopic;
  }
  /**
   * @return string
   */
  public function getPubsubTopic()
  {
    return $this->pubsubTopic;
  }
  /**
   * Sign-in details of the enterprise.
   *
   * @param SigninDetail[] $signinDetails
   */
  public function setSigninDetails($signinDetails)
  {
    $this->signinDetails = $signinDetails;
  }
  /**
   * @return SigninDetail[]
   */
  public function getSigninDetails()
  {
    return $this->signinDetails;
  }
  /**
   * Terms and conditions that must be accepted when provisioning a device for
   * this enterprise. A page of terms is generated for each value in this list.
   *
   * @param TermsAndConditions[] $termsAndConditions
   */
  public function setTermsAndConditions($termsAndConditions)
  {
    $this->termsAndConditions = $termsAndConditions;
  }
  /**
   * @return TermsAndConditions[]
   */
  public function getTermsAndConditions()
  {
    return $this->termsAndConditions;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Enterprise::class, 'Google_Service_AndroidManagement_Enterprise');
