<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Analytics;

class GaDataColumnHeaders extends \Google\Model
{
  /**
   * Column Type. Either DIMENSION or METRIC.
   *
   * @var string
   */
  public $columnType;
  /**
   * Data type. Dimension column headers have only STRING as the data type.
   * Metric column headers have data types for metric values such as INTEGER,
   * DOUBLE, CURRENCY etc.
   *
   * @var string
   */
  public $dataType;
  /**
   * Column name.
   *
   * @var string
   */
  public $name;

  /**
   * Column Type. Either DIMENSION or METRIC.
   *
   * @param string $columnType
   */
  public function setColumnType($columnType)
  {
    $this->columnType = $columnType;
  }
  /**
   * @return string
   */
  public function getColumnType()
  {
    return $this->columnType;
  }
  /**
   * Data type. Dimension column headers have only STRING as the data type.
   * Metric column headers have data types for metric values such as INTEGER,
   * DOUBLE, CURRENCY etc.
   *
   * @param string $dataType
   */
  public function setDataType($dataType)
  {
    $this->dataType = $dataType;
  }
  /**
   * @return string
   */
  public function getDataType()
  {
    return $this->dataType;
  }
  /**
   * Column name.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GaDataColumnHeaders::class, 'Google_Service_Analytics_GaDataColumnHeaders');
