<?php

	/* Permissions if is logged */
	function idLogged() {
		return containsPermission($_SESSION["activo"], "1");
	}

	function getNickname() {
		return decodeData($_SESSION["alias"]);
	}

	function getNicknameEncoded() {
		return $_SESSION["alias"];
	}

	function getFullname() {
		return decodeData($_SESSION["nombre"]) . " " . decodeData($_SESSION["apellido"]);
	}

	function getRole() {
		return decodeData($_SESSION["perfil"]);
	}

	function getSponsor() {
		return decodeData($_SESSION["patrocinador"]);
	}

	/* Permissions related to Plans */
    function canReadPlans() {
		return containsPermission($_SESSION["permiso_planes"], "r");
	}
	function canUpdatePlans() {
		return containsPermission($_SESSION["permiso_planes"], "u");
	}
    function canSupervisePlans() {
		return containsPermission($_SESSION["permiso_planes"], "s");
	}

	/* Extra utils */
	function containsPermission($main, $substring) {
    	return strpos($main, $substring) !== false;
	}

	function encodeData($dato) {
		$resultado = $dato;
		$arrayLetras = array('N', 'O', 'E', 'L', 'I', 'A');
		$limite = count($arrayLetras) - 1;
		$num = mt_rand(0, $limite);
		for ($i = 1; $i <= $num; $i++) {
			$resultado = base64_encode($resultado);
		}
		$resultado = $resultado . '+' . $arrayLetras[$num];
		$resultado = base64_encode($resultado);
		return $resultado;
	}

	function decodeData($dato) {
		$resultado = base64_decode($dato);
		list($resultado, $letra) = explode('+', $resultado);
		$arrayLetras = array('N', 'O', 'E', 'L', 'I', 'A');
		for ($i = 0; $i < count($arrayLetras); $i++) {
			if ($arrayLetras[$i] == $letra) {
				for ($j = 1; $j <= $i; $j++) {
					$resultado = base64_decode($resultado);
				}
				break;
			}
		}
		return $resultado;
	}
?>