<?php
    require_once '../../config/config.php';

    $google_client = new Google_Client();
    $google_client->setClientId(GOOGLE_CLIENT_ID);
    $google_client->setClientSecret(GOOGLE_CLIENT_SECRET);
    $google_client->setRedirectUri(GOOGLE_REDIRECT_URI);

    if (isset($_GET['code'])) {
        $token = $google_client->fetchAccessTokenWithAuthCode($_GET['code']);
        
        if (!isset($token['error'])) {
            $google_client->setAccessToken($token['access_token']);
            $google_service = new Google_Service_Oauth2($google_client);
            $userInfo = $google_service->userinfo->get();

            // Guardar información del usuario en la sesión
            $_SESSION['user_id'] = [
                'user_email' => $userInfo->email,
                'user_name' => $userInfo->name,
                'user_picture' => $userInfo->picture
            ];



            //$_SESSION['user_id'] = $userInfo->id;
            //$_SESSION['user_name'] = $userInfo->name;
            //$_SESSION['user_email'] = $userInfo->email;
            //$_SESSION['user_picture'] = $userInfo->picture;

            setcookie(COOKIE_NAME,session_id(),time()+COOKIE_DAYS*86400,"/");
            
            // Aquí podrías insertar o actualizar el usuario en tu base de datos
            
            header('Location: ../home/index.php');
            exit();
        }
    }

    // Si falla, redirige al login
    header('Location: /pages/login.php');
    exit();
?>